<?php
namespace Void_ewhmcsep\Widgets;

use Elementor\Widget_Base;
use Elementor\Controls_Manager;

if ( ! defined( 'ABSPATH' ) ) exit; // Exit if accessed directly

/**
 * Elementor Style for header
 *
 *
 * @since 1.0.0
 */

class Section_Login extends Widget_Base {

	public function get_name() {
		return 'section-login'; 
	}

	public function get_title() {
		return 'Login Form';   // title to show on elementor
	}

	public function get_icon() {
		return 'eicon-person';    //   eicon-posts-ticker-> eicon ow asche icon to show on elelmentor
	}

	public function get_categories() {
		return [ 'void-elements' ];    // category of the widget
	}

	
	/**
	 * A list of scripts that the widgets is depended in
	 * @since 1.3.0
	 **/

	protected function register_controls() {
		
//start of a control box
		$this->start_controls_section(
			'section_content',
			[
				'label' => esc_html__( 'Content', 'void_ewhmcsep' ),   //section name for controler view
			]
		);

		$this->add_control(
			'login_header',
			[
				'label' => __( 'Login Header', 'void_ewhmcsep' ),
				'type' => Controls_Manager::TEXT,
				'default' => 'Welcome Back!',
			]
		);

		$this->add_control(
			'login_sub_header',
			[
				'label' => __( 'Login Sub Header', 'void_ewhmcsep' ),
				'type' => Controls_Manager::TEXT,
				'default' => 'Login to your account below',
			]
		);

		$this->end_controls_section();

//End  of a control box

//start of a control box
		$this->start_controls_section(
			'section_style',
			[
				'label' => esc_html__( 'Style', 'void_ewhmcsep' ),
				'tab' => Controls_Manager::TAB_STYLE,
			]
		);
		
		$this->add_control(
			'whmcs_url',
			[
				'label' => __( 'WHMCS URL', 'void_ewhmcsep' ),
				'description' => __( 'Used when you do not have WHMCS Bridge Plugin installed to get/send data. Do not add (/). Just input direct url of your whmcs area (not admin url). ex: https://testsite/whmcs', 'void_ewhmcsep' ),
				'type' => Controls_Manager::TEXT,
				'label_block' => true,
				'default' => 'https://voidcoders.com/voidwhmcs',
			]
		);
		$this->add_control(
			'login_box',
			[
				'label' => __( 'Login Box Css', 'void_ewhmcsep' ),
				'type' => Controls_Manager::TEXTAREA,
				'placeholder'	=> 'color:red;',
				'selectors' => [
					'{{WRAPPER}}  .login-box' => '{{VALUE}};',
				],
			]
		);		

		$this->add_control(
			'header_css',
			[
				'label' => __( 'Login Header Css', 'void_ewhmcsep' ),
				'type' => Controls_Manager::TEXTAREA,
				'placeholder'	=> 'color:red;',
				'selectors' => [
					'{{WRAPPER}}  .lb-title' => '{{VALUE}};',
				],
			]
		);		

		$this->add_control(
			'header_css2',
			[
				'label' => __( 'Login Sub Header Css', 'void_ewhmcsep' ),
				'type' => Controls_Manager::TEXTAREA,
				'placeholder'	=> 'color:red;',
				'selectors' => [
					'{{WRAPPER}}  .lb-text' => '{{VALUE}};',
				],
			]
		);	

		$this->add_control(
			'input_textcss',
			[
				'label' => __( 'Input Css', 'void_ewhmcsep' ),
				'type' => Controls_Manager::TEXTAREA,
				'placeholder'	=> 'color:red;',
				'selectors' => [
					'{{WRAPPER}}  .login-box input' => '{{VALUE}};',
				],
			]
		);	
		$this->add_control(
			'remember1',
			[
				'label' => __( 'Remember Me Area', 'void_ewhmcsep' ),
				'type' => Controls_Manager::TEXTAREA,
				'placeholder'	=> 'color:red;',
				'selectors' => [
					'{{WRAPPER}}  .lb-remember' => '{{VALUE}};',
				],
			]
		);		
		$this->add_control(
			'remember2',
			[
				'label' => __( 'Remember Me Checkbox Css', 'void_ewhmcsep' ),
				'type' => Controls_Manager::TEXTAREA,
				'placeholder'	=> 'color:red;',
				'selectors' => [
					'{{WRAPPER}}  .lb-remember input[type="checkbox"]' => '{{VALUE}};',
				],
			]
		);	
		$this->add_control(
			'input_submitcss',
			[
				'label' => __( 'Submit Css', 'void_ewhmcsep' ),
				'type' => Controls_Manager::TEXTAREA,
				'placeholder'	=> 'color:red;',
				'selectors' => [
					'{{WRAPPER}}  .login-box input[type="submit"]' => '{{VALUE}};',
				],
			]
		);			
		$this->add_control(
			'forgot_createcss',
			[
				'label' => __( 'Login Bottom Area css', 'void_ewhmcsep' ),
				'type' => Controls_Manager::TEXTAREA,
				'placeholder'	=> 'color:red;',
				'selectors' => [
					'{{WRAPPER}}  .forgot-create' => '{{VALUE}};',
				],
			]
		);			
		$this->add_control(
			'forgot_createcss2',
			[
				'label' => __( 'Login Bottom Area Link css', 'void_ewhmcsep' ),
				'type' => Controls_Manager::TEXTAREA,
				'placeholder'	=> 'color:red;',
				'selectors' => [
					'{{WRAPPER}}  .forgot-create a' => '{{VALUE}};',
				],
			]
		);	

		$this->end_controls_section();
	}

//end of control box 

	protected function render() {		
			//to show on the fontend 
	global $void_option, $no_option, $allowedposttags, $whmcs_bridge_enabled;
		
	$settings = $this->get_settings();

	?>

	<div class="login">   
	    <div class="login-box">
	        <h2 class="lb-title"><?php echo $settings['login_header']; ?></h2>
	        <span class="lb-text"><?php echo $settings['login_sub_header']; ?></span>
            <form method="post" action="<?php if($whmcs_bridge_enabled==1){ echo esc_url(void_ewhmcsep_whmcs_bridge_url() .'?ccce=dologin'); } else{ echo esc_url($settings['whmcs_url'].'/dologin.php'); }  ?>">
	            <input type="text"  name="username" placeholder="<?php esc_html_e('Email Address','void_ewhmcsep'); ?>">
	            <input type="password" name="password" placeholder="<?php esc_html_e('Password','void_ewhmcsep'); ?>">
	            <div class="lb-remember">
	                <input type="checkbox" name="rememberme">
	                <label><?php esc_html_e('Remember me','void_ewhmcsep'); ?></label>
	            </div>
	            <input type="submit" value="<?php esc_html_e('Login','void_ewhmcsep'); ?>">
	        </form>
	    </div>
	    <div class="forgot-create">
	        <a class="fc-forgot" href="<?php if($whmcs_bridge_enabled==1){ echo esc_url(void_ewhmcsep_whmcs_bridge_url() .'?ccce=pwreset'); } else{ echo esc_url($settings['whmcs_url'].'/pwreset.php'); }  ?>"><?php esc_html_e('Forgot Password','void_ewhmcsep' ); ?></a>
	        <a class="fc-create" href="<?php if($whmcs_bridge_enabled==1){ echo esc_url(void_ewhmcsep_whmcs_bridge_url() .'?ccce=register'); } else{ echo esc_url($settings['whmcs_url'].'/register.php'); }  ?>"><?php esc_html_e('Register Account','void_ewhmcsep' ); ?></a>
	    </div>
	</div>

	<?php	}

	protected function content_template() {      // to be in live preview edit
	
	}
}
